﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//In diesem Namespace liegen alle Thread-Bezogenen Objekte
using System.Threading;

namespace KursBeispiele
{
    public delegate void AddTextDelegate(string msg, TextBox tb);
    public delegate void AddComboBoxDelegate(string content);
    public delegate void UpdateTextDelegate();

    public partial class Form1 : Form
    {
        #region Allgemeines

        Thread counter;
        AddTextDelegate adt;
        AddComboBoxDelegate acb;
        UpdateTextDelegate utd;
        int shared;
        int summe;
        System.Threading.Timer timer;

        public Form1()
        {
            InitializeComponent();
            //Die Delegaten festlegen um Text hinzuzufügen
            adt = new AddTextDelegate(AddText);
            acb = new AddComboBoxDelegate(AddComboBox);
            utd = new UpdateTextDelegate(UpdateSumme);

            //Aktuelle UI Sprache anzeigen (wir können diese aber auch ändern!)
            MessageBox.Show(Thread.CurrentThread.CurrentCulture.ToString());
        }

        //Funktion welche Text hinzufügt -> Thread sicher gemacht worden d.h. wir können diese von
        //einem anderen Thread aufrufen!
        private void AddText(string msg, TextBox tb)
        {
            //Nachschauen ob wir den delegaten benötigen
            if (tb.InvokeRequired) //Ja! Daher den Delegaten verwenden
                tb.Invoke(adt, msg, tb);
            else
            {
                //Hier wird der Text hinzugefügt und bis zum Schluss des Textes gescrollt...
                tb.Text += msg + "\r\n";
                tb.SelectionStart = tb.TextLength;
                tb.ScrollToCaret();

                //Wenn wir das in unserem UI Thread ablaufen lassen sehen wir nie wieder einen
                //sog. REPAINT - also brauchen wir noch etwas ...
                //Application.DoEvents();
            }
        }

        #endregion

        #region Thread starten und stoppen

        //Wir starten einen neuen Thread
        private void button1_Click(object sender, EventArgs e)
        {
            textBox1.Clear();
            //Legen den Start Button auf Disabled und setzen den Stopp Button auf Enabled
            button1.Enabled = false;
            button2.Enabled = true;
            //Threadstart ist ein Delegate - wir übergeben dem Thread einen
            //Funktionspointer (Delegate) als Argument - das wird der Einstiegspunkt
            //für unseren Thread (VGL: Hauptthread hatte als Einstiegsfunktion Main(...))
            ThreadStart ts = new ThreadStart(threadTarget);
            counter = new Thread(ts);
            //Startet den Thread
            counter.Start();
        }

        //Wir stoppen einen neuen Thread
        private void button2_Click(object sender, EventArgs e)
        {
            //Legen den Stopp Button auf Disabled und setzen den Start Button auf Enabled
            button1.Enabled = true;
            button2.Enabled = false;
            //Thread abbrechen
            counter.Abort();
        }

        //Einstiegsfunktion für unseren Thread
        private void threadTarget()
        {
            int i = 0;

            while (true)
            {
                i++;
                Thread.Sleep(500);
                //So BITTE nicht... -> Kein DIREKTER Zugriff vom einen auf den anderen Thread!
                textBox1.Text += i.ToString() + "\n";
                //So wird das ganze gemacht: Externe Funktion welche überprüft ob das gültig ist
                //AddText(i.ToString(), textBox1);
            }
        }

        #endregion

        #region Ohne Thread

        //Wir starten unsere Schleife OHNE die Verwendung eines zusätzlichen Threads
        private void button3_Click(object sender, EventArgs e)
        {
            threadTarget();
        }

        #endregion

        #region Mehrere Threads

        //Startet mehrere Threads
        private void button4_Click(object sender, EventArgs e)
        {
            textBox2.Clear();
            //Die gemeinsame Variable initialisieren
            shared = 0;
            //Neue Threads hinzufügen - soviele wie wir angegeben haben
            for (int i = 0; i < decimal.ToInt32( numericUpDown1.Value ); i++)
                ThreadPool.QueueUserWorkItem(new WaitCallback(threadPoolTargets), i);
        }

        //Einstiegsfunktion für unsere Threads
        private void threadPoolTargets(object ID)
        {
            int add = (int)ID % 2 == 0 ? 1 : -1;

            for(int i = 0; i < 10; i++)
            {
                shared += add;
                //Nutzen wieder unser AddText
                AddText(shared.ToString() + " gesendet von Thread ID " + ID, textBox2);
            }
        }

        #endregion

        #region Timer Threads

        //Startet einen Timer Thread
        private void button5_Click(object sender, EventArgs e)
        {
            //Mehrdeutiger Name! Sowohl der Timer als auch der (Thread)Timer heißen Timer... Müssen auswählen!
            timer = new System.Threading.Timer(new TimerCallback(TimerExecute), "Timer ausgabe", 1000, 500);
            //Wir übergeben unserer Funktion eine Referenz auf das Objekt... -> haben Zugriff!
        }

        private void TimerExecute(object obj)
        {
            //Ausgabe - erstmal casten
            string s = obj as string;
            //Der ComboBox hinzufügen
            AddComboBox(s);
            //Ändern der zeitlichen Reihenfolge => wollen jetzt ein wenig mehr Abstand haben
            timer.Change(1000, 100000);//Wieso geht dies nicht?
        }

        private void AddComboBox(string msg)
        {
            if (this.InvokeRequired)
                this.Invoke(acb, msg);
            else
                comboBox1.Items.Add(msg);
        }

        #endregion

        #region Locking testen

        private void button6_Click(object sender, EventArgs e)
        {
            //Variable auf 0 stehen
            summe = 0;
            Thread t1 = new Thread(LockTest);
            Thread t2 = new Thread(LockTest);
            t1.Name = "Erster Thread";
            t2.Name = "Zweiter Thread";
            t1.Start(1);
            t2.Start(-1);
        }

        private void LockTest(object anzahl)
        {
            //Vergleiche mit und ohne locked
            //lock (this) 
            //{
                for (int i = 0; i < 5; i++)
                {
                    //Gekünstelt aber verdeutlicht Problem
                    int buffer = summe;
                    Thread.Sleep(100);
                    summe = buffer + (int)anzahl;
                }
            //}

            UpdateSumme();
        }

        private void UpdateSumme()
        {
            if (InvokeRequired)
                Invoke(utd);
            else
                textBox3.Text = "Das Ergebnis war " + summe.ToString();
        }

        #endregion
    }
}
